/*
 * Decompiled with CFR 0.152.
 */
package com.github.dima_dencep.mods.online_emotes.netty;

import com.github.dima_dencep.mods.online_emotes.OnlineEmotes;
import com.github.dima_dencep.mods.online_emotes.network.OnlineNetworkInstance;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.jetbrains.annotations.NotNull;

@ChannelHandler.Sharable
public class WebsocketHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private final OnlineNetworkInstance proxy;

    public WebsocketHandler(OnlineNetworkInstance proxy) {
        this.proxy = proxy;
    }

    public void channelInactive(@NotNull ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        OnlineEmotes.sendMessage(true, null, "WebSocket disconnected!");
        OnlineEmotes.LOGGER.info("WebSocket disconnected!");
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        OnlineEmotes.sendMessage(true, null, "WebSocket connected!");
        OnlineEmotes.LOGGER.info("WebSocket connected!");
    }

    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame msg) {
        if (msg instanceof BinaryWebSocketFrame) {
            BinaryWebSocketFrame frame = (BinaryWebSocketFrame)msg;
            ByteBuf buf = frame.content();
            if (!buf.isDirect() && !buf.isReadOnly()) {
                this.proxy.receiveMessage(buf.array());
            } else {
                byte[] bytes = new byte[buf.readableBytes()];
                buf.getBytes(buf.readerIndex(), bytes);
                this.proxy.receiveMessage(bytes);
            }
        } else if (msg instanceof TextWebSocketFrame) {
            TextWebSocketFrame frame = (TextWebSocketFrame)msg;
            OnlineEmotes.sendMessage(false, null, frame.text());
        } else if (msg instanceof PingWebSocketFrame) {
            PingWebSocketFrame frame = (PingWebSocketFrame)msg;
            frame.content().retain();
            ctx.channel().writeAndFlush((Object)new PongWebSocketFrame(frame.content()), ctx.channel().voidPromise());
        } else if (msg instanceof CloseWebSocketFrame) {
            ctx.channel().close();
        } else {
            OnlineEmotes.LOGGER.error("Unsupported frame type: %s!", (Object)msg.getClass().getName());
        }
    }
}

