/*
 * Decompiled with CFR 0.152.
 */
package com.github.dima_dencep.mods.online_emotes.network;

import com.github.dima_dencep.mods.online_emotes.OnlineEmotes;
import com.github.dima_dencep.mods.online_emotes.config.EmoteConfig;
import com.github.dima_dencep.mods.online_emotes.netty.HandshakeHandler;
import com.github.dima_dencep.mods.online_emotes.netty.WebsocketHandler;
import com.github.dima_dencep.mods.online_emotes.utils.EmotePacketWrapper;
import com.github.dima_dencep.mods.online_emotes.utils.NettyObjectFactory;
import io.github.kosmx.emotes.api.proxy.AbstractNetworkInstance;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.util.concurrent.ScheduledFuture;
import java.io.IOException;
import java.net.URI;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ChannelHandler.Sharable
public class OnlineNetworkInstance
extends AbstractNetworkInstance {
    public static final URI URI_ADDRESS = URI.create(EmoteConfig.INSTANCE.address);
    public final Bootstrap bootstrap = new Bootstrap();
    private ScheduledFuture<?> reconnectingFuture;
    public HandshakeHandler handshakeHandler;
    public Channel ch;

    public OnlineNetworkInstance() {
        if (!"ws".equals(URI_ADDRESS.getScheme()) && !"wss".equals(URI_ADDRESS.getScheme())) {
            throw new IllegalArgumentException("Unsupported protocol: " + URI_ADDRESS.getScheme());
        }
        this.bootstrap.group(NettyObjectFactory.newEventLoopGroup());
        this.bootstrap.channel(NettyObjectFactory.getSocketChannel());
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(@NotNull SocketChannel ch) throws SSLException {
                ChannelPipeline pipeline = ch.pipeline();
                if ("wss".equals(URI_ADDRESS.getScheme())) {
                    pipeline.addLast(new ChannelHandler[]{SslContextBuilder.forClient().build().newHandler(ch.alloc(), URI_ADDRESS.getHost(), URI_ADDRESS.getPort())});
                }
                pipeline.addLast("http-codec", (ChannelHandler)new HttpClientCodec());
                pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
                pipeline.addLast("handshaker", (ChannelHandler)OnlineNetworkInstance.this.handshakeHandler);
                pipeline.addLast("ws-handler", (ChannelHandler)new WebsocketHandler(OnlineNetworkInstance.this));
            }
        });
    }

    public void connect() {
        this.stopReconnecting();
        this.reconnectingFuture = this.bootstrap.config().group().scheduleAtFixedRate(() -> {
            if (!this.isActive()) {
                OnlineEmotes.LOGGER.info("Try (re)connecting...");
                this.connectInternal();
            }
        }, 0L, EmoteConfig.INSTANCE.reconnectionDelay, TimeUnit.SECONDS);
    }

    private void connectInternal() {
        this.handshakeHandler = new HandshakeHandler(WebSocketClientHandshakerFactory.newHandshaker((URI)URI_ADDRESS, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)false, (HttpHeaders)EmptyHttpHeaders.INSTANCE, (int)12800000));
        ChannelFuture channelFuture = this.bootstrap.connect(URI_ADDRESS.getHost(), URI_ADDRESS.getPort());
        channelFuture.addListener(l -> {
            if (l.isSuccess()) {
                this.disconnectNetty();
                this.ch = channelFuture.channel();
                this.handshakeHandler.handshakeFuture.addListener(e -> {
                    if (e.isSuccess()) {
                        this.sendConfigCallback();
                    } else {
                        OnlineEmotes.LOGGER.error((Object)e.cause());
                    }
                });
            } else {
                OnlineEmotes.LOGGER.error((Object)l.cause());
            }
        });
    }

    public boolean sendPlayerID() {
        return false;
    }

    public boolean isActive() {
        return this.ch != null && this.ch.isActive();
    }

    public void sendMessage(EmotePacket.Builder builder, @Nullable UUID target) throws IOException {
        if (target != null) {
            builder.configureTarget(target);
        }
        EmotePacket writer = builder.build();
        this.ch.writeAndFlush((Object)new EmotePacketWrapper(writer.write().array()).toWebSocketFrame(), this.ch.voidPromise());
        if (writer.data.emoteData != null && writer.data.emoteData.extraData.containsKey("song") && !writer.data.writeSong) {
            EmoteInstance.instance.getClientMethods().sendChatMessage(EmoteInstance.instance.getDefaults().newTranslationText("emotecraft.song_too_big_to_send"));
        }
    }

    public void disconnectNetty() {
        if (this.isActive()) {
            this.ch.writeAndFlush((Object)new CloseWebSocketFrame(), this.ch.voidPromise());
            try {
                this.ch.closeFuture().sync();
            }
            catch (Throwable th) {
                OnlineEmotes.LOGGER.error("Failed to disconnect WebSocket:", th);
            }
        }
    }

    public void disconnect() {
        this.stopReconnecting();
        this.disconnectNetty();
        super.disconnect();
    }

    public void stopReconnecting() {
        try {
            if (this.reconnectingFuture != null && !this.reconnectingFuture.isCancelled()) {
                OnlineEmotes.LOGGER.warn("What happened to the reconnector?");
                this.reconnectingFuture.cancel(true);
                this.reconnectingFuture = null;
            }
        }
        catch (Throwable th) {
            OnlineEmotes.LOGGER.error("Failed to stop reconnector:", th);
        }
    }
}

