/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.spectator;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import su.plo.config.provider.ConfigurationProvider;
import su.plo.config.provider.toml.TomlConfiguration;
import su.plo.slib.api.server.entity.McServerEntity;
import su.plo.slib.api.server.entity.player.McServerPlayer;
import su.plo.slib.api.server.position.ServerPos3d;
import su.plo.voice.api.addon.AddonInitializer;
import su.plo.voice.api.addon.AddonLoaderScope;
import su.plo.voice.api.addon.InjectPlasmoVoice;
import su.plo.voice.api.addon.annotation.Addon;
import su.plo.voice.api.event.EventCancellableBase;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.api.server.PlasmoVoiceServer;
import su.plo.voice.api.server.audio.source.ServerEntitySource;
import su.plo.voice.api.server.audio.source.ServerPlayerSource;
import su.plo.voice.api.server.audio.source.ServerProximitySource;
import su.plo.voice.api.server.audio.source.ServerStaticSource;
import su.plo.voice.api.server.event.audio.source.ServerSourceAudioPacketEvent;
import su.plo.voice.api.server.event.audio.source.ServerSourcePacketEvent;
import su.plo.voice.api.server.event.config.VoiceServerConfigReloadedEvent;
import su.plo.voice.api.server.event.connection.UdpClientDisconnectedEvent;
import su.plo.voice.api.server.player.VoiceServerPlayer;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.data.audio.codec.opus.OpusDecoderInfo;
import su.plo.voice.proto.data.audio.source.PlayerSourceInfo;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.tcp.clientbound.SourceAudioEndPacket;
import su.plo.voice.proto.packets.udp.clientbound.SourceAudioPacket;
import su.plo.voice.spectator.SpectatorConfig;

@Addon(id="pv-addon-spectator", scope=AddonLoaderScope.SERVER, version="1.1.0", authors={"Apehum"})
public final class SpectatorAddon
implements AddonInitializer {
    private static final ConfigurationProvider toml = (ConfigurationProvider)ConfigurationProvider.getProvider(TomlConfiguration.class);
    @InjectPlasmoVoice
    private PlasmoVoiceServer voiceServer;
    private SpectatorConfig config;
    private final Map<SourceLineKey, ServerStaticSource> staticSourceByLineKey = Maps.newConcurrentMap();
    private final Map<SourceLineKey, ServerEntitySource> entitySourceByLineKey = Maps.newConcurrentMap();
    private final Map<UUID, Long> lastPlayerPositionTimestampById = Maps.newConcurrentMap();

    public void onAddonInitialize() {
        this.loadConfig();
    }

    @EventSubscribe
    public void onConfigLoaded(@NotNull VoiceServerConfigReloadedEvent event) {
        this.loadConfig();
    }

    @EventSubscribe
    public void onClientDisconnect(@NotNull UdpClientDisconnectedEvent event) {
        VoiceServerPlayer player = (VoiceServerPlayer)event.getConnection().getPlayer();
        this.removeSources(player);
    }

    @EventSubscribe
    public void onSourceAudioPacket(@NotNull ServerSourceAudioPacketEvent event) {
        if (!(event.getSource() instanceof ServerPlayerSource)) {
            return;
        }
        ServerPlayerSource playerSource = (ServerPlayerSource)event.getSource();
        SourceAudioPacket sourcePacket = event.getPacket();
        VoiceServerPlayer player = playerSource.getPlayer();
        this.getTargetSource(playerSource, player, (EventCancellableBase)event).ifPresent(source -> {
            SourceAudioPacket sourceAudioPacket = new SourceAudioPacket(event.getPacket().getSequenceNumber(), 0, sourcePacket.getData(), source.getId(), event.getDistance());
            if (source instanceof ServerStaticSource) {
                source.sendAudioPacket(sourceAudioPacket, event.getDistance());
            } else {
                source.sendAudioPacket(sourceAudioPacket, event.getDistance(), event.getActivationInfo());
            }
        });
    }

    @EventSubscribe
    public void onSourcePacket(@NotNull ServerSourcePacketEvent event) {
        if (!(event.getSource() instanceof ServerPlayerSource)) {
            return;
        }
        ServerPlayerSource playerSource = (ServerPlayerSource)event.getSource();
        Packet sourcePacket = event.getPacket();
        VoiceServerPlayer player = playerSource.getPlayer();
        this.getTargetSource(playerSource, player, (EventCancellableBase)event).ifPresent(source -> {
            if (!(sourcePacket instanceof SourceAudioEndPacket)) {
                return;
            }
            SourceAudioEndPacket sourceEndPacket = (SourceAudioEndPacket)sourcePacket;
            SourceAudioEndPacket targetSourcePacket = new SourceAudioEndPacket(source.getId(), sourceEndPacket.getSequenceNumber());
            source.sendPacket((Packet)targetSourcePacket, event.getDistance());
        });
    }

    private void loadConfig() {
        try {
            File addonFolder = new File(this.voiceServer.getMinecraftServer().getConfigsFolder(), "pv-addon-spectator");
            File configFile = new File(addonFolder, "config.toml");
            this.config = (SpectatorConfig)toml.load(SpectatorConfig.class, configFile, false);
            toml.save(SpectatorConfig.class, (Object)this.config, configFile);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load config", e);
        }
        this.staticSourceByLineKey.forEach((playerId, source) -> source.setIconVisible(this.config.showIcon()));
    }

    private Optional<ServerProximitySource<?>> getTargetSource(@NotNull ServerPlayerSource source, @NotNull VoiceServerPlayer player, @NotNull EventCancellableBase event) {
        if (!player.getInstance().isSpectator()) {
            this.removeSources(player);
            return Optional.empty();
        }
        if (player.getInstance().getSpectatorTarget() != null) {
            event.setCancelled(true);
            return Optional.of(this.getEntitySource(source, player));
        }
        return Optional.of(this.getStaticSource(source, player));
    }

    private void removeSources(@NotNull VoiceServerPlayer player) {
        UUID playerUuid = player.getInstance().getUuid();
        this.lastPlayerPositionTimestampById.remove(playerUuid);
        this.staticSourceByLineKey.entrySet().stream().filter(entry -> ((SourceLineKey)entry.getKey()).playerId.equals(playerUuid)).forEach(entry -> {
            this.staticSourceByLineKey.remove(entry.getKey());
            ((ServerStaticSource)entry.getValue()).remove();
        });
        this.entitySourceByLineKey.entrySet().stream().filter(entry -> ((SourceLineKey)entry.getKey()).playerId.equals(playerUuid)).forEach(entry -> {
            this.entitySourceByLineKey.remove(entry.getKey());
            ((ServerEntitySource)entry.getValue()).remove();
        });
    }

    private ServerStaticSource getStaticSource(@NotNull ServerPlayerSource playerSource, @NotNull VoiceServerPlayer player) {
        PlayerSourceInfo sourceInfo = (PlayerSourceInfo)playerSource.getSourceInfo();
        SourceLineKey sourceLineKey = new SourceLineKey(player.getInstance().getUuid(), playerSource.getLine().getId());
        ServerStaticSource staticSource = this.staticSourceByLineKey.computeIfAbsent(sourceLineKey, sourceId -> {
            ServerStaticSource source = playerSource.getLine().createStaticSource(player.getInstance().getServerPosition(), sourceInfo.isStereo(), (CodecInfo)new OpusDecoderInfo());
            source.setIconVisible(this.config.showIcon());
            source.addFilter(listener -> !listener.equals(player) && !((McServerPlayer)listener.getInstance()).isSpectator());
            return source;
        });
        staticSource.setStereo(sourceInfo.isStereo());
        staticSource.setName(player.getInstance().getName());
        this.updateSourcePosition(player, staticSource);
        return staticSource;
    }

    private ServerEntitySource getEntitySource(@NotNull ServerPlayerSource playerSource, @NotNull VoiceServerPlayer player) {
        PlayerSourceInfo sourceInfo = (PlayerSourceInfo)playerSource.getSourceInfo();
        SourceLineKey sourceLineKey = new SourceLineKey(player.getInstance().getUuid(), playerSource.getLine().getId());
        McServerEntity spectatorTarget = player.getInstance().getSpectatorTarget();
        ServerEntitySource entitySource = this.entitySourceByLineKey.get(sourceLineKey);
        if (entitySource == null || !entitySource.getEntity().getInstance().equals(spectatorTarget.getInstance())) {
            entitySource = playerSource.getLine().createEntitySource(spectatorTarget, sourceInfo.isStereo());
            entitySource.setIconVisible(this.config.showIcon());
            entitySource.addFilter(listener -> !listener.equals(player));
            this.entitySourceByLineKey.put(sourceLineKey, entitySource);
        }
        entitySource.setStereo(sourceInfo.isStereo());
        entitySource.setName(player.getInstance().getName());
        return entitySource;
    }

    private void updateSourcePosition(@NotNull VoiceServerPlayer player, @NotNull ServerStaticSource source) {
        long lastUpdate = this.lastPlayerPositionTimestampById.getOrDefault(player.getInstance().getUuid(), 0L);
        if (System.currentTimeMillis() - lastUpdate < 100L) {
            return;
        }
        ServerPos3d position = player.getInstance().getServerPosition();
        position.setY(position.getY() + (double)player.getInstance().getHitBoxHeight() + 0.5);
        source.setPosition(position);
        this.lastPlayerPositionTimestampById.put(player.getInstance().getUuid(), System.currentTimeMillis());
    }

    private class SourceLineKey {
        private final UUID playerId;
        private final UUID sourceLineId;

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SourceLineKey)) {
                return false;
            }
            SourceLineKey other = (SourceLineKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$playerId = this.playerId;
            UUID other$playerId = other.playerId;
            if (this$playerId == null ? other$playerId != null : !((Object)this$playerId).equals(other$playerId)) {
                return false;
            }
            UUID this$sourceLineId = this.sourceLineId;
            UUID other$sourceLineId = other.sourceLineId;
            return !(this$sourceLineId == null ? other$sourceLineId != null : !((Object)this$sourceLineId).equals(other$sourceLineId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SourceLineKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $playerId = this.playerId;
            result = result * 59 + ($playerId == null ? 43 : ((Object)$playerId).hashCode());
            UUID $sourceLineId = this.sourceLineId;
            result = result * 59 + ($sourceLineId == null ? 43 : ((Object)$sourceLineId).hashCode());
            return result;
        }

        public SourceLineKey(UUID playerId, UUID sourceLineId) {
            this.playerId = playerId;
            this.sourceLineId = sourceLineId;
        }
    }
}

