/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.mixins.client;

import com.aizistral.nochatreports.common.NCRCore;
import com.aizistral.nochatreports.common.config.NCRConfig;
import com.aizistral.nochatreports.common.core.EncryptionUtil;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_338;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7591;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={class_338.class})
public class MixinChatComponent {
    private static final class_7591.class_7592 ENCRYPTED_ICON = class_7591.class_7592.valueOf((String)"CHAT_NCR_ENCRYPTED");
    private boolean lastMessageEncrypted;
    private class_2561 lastMessageOriginal;

    @ModifyVariable(method={"addRecentChat"}, at=@At(value="HEAD"), argsOnly=true)
    private String onAddRecentChat(String message) {
        if (NCRConfig.getEncryption().isEnabledAndValid()) {
            return NCRConfig.getEncryption().getLastMessage();
        }
        return message;
    }

    @ModifyVariable(method={"addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;ILnet/minecraft/client/GuiMessageTag;Z)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/ComponentRenderUtils;wrapComponents(Lnet/minecraft/network/chat/FormattedText;ILnet/minecraft/client/gui/Font;)Ljava/util/List;", ordinal=0, shift=At.Shift.AFTER), argsOnly=true)
    private synchronized class_7591 modifyGUITag(class_7591 tag) {
        if (!NCRConfig.getEncryption().showEncryptionIndicators() || !this.lastMessageEncrypted) {
            return tag;
        }
        this.lastMessageEncrypted = false;
        class_5250 tooltip = class_2561.method_43473().method_10852((class_2561)class_2561.method_43469((String)"tag.nochatreports.encrypted", (Object[])new Object[]{class_2561.method_43470((String)NCRConfig.getEncryption().getAlgorithm().getName()).method_27692(class_124.field_1067)})).method_10852(class_5244.field_33849).method_10852((class_2561)class_2561.method_43469((String)"tag.nochatreports.encrypted_original", (Object[])new Object[]{this.lastMessageOriginal}));
        return new class_7591(9125575, ENCRYPTED_ICON, (class_2561)tooltip, "Encrypted");
    }

    @ModifyArg(index=0, method={"addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;ILnet/minecraft/client/GuiMessageTag;Z)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/ComponentRenderUtils;wrapComponents(Lnet/minecraft/network/chat/FormattedText;ILnet/minecraft/client/gui/Font;)Ljava/util/List;", ordinal=0))
    private class_5348 modifyGUIMessage(class_5348 msg) {
        if (NCRConfig.getCommon().enableDebugLog()) {
            NCRCore.LOGGER.info("Adding chat message, structure: " + class_2561.class_2562.method_43858((class_2561)((class_2561)msg)));
        }
        Optional<class_2561> decrypted = EncryptionUtil.tryDecrypt((class_2561)msg);
        decrypted.ifPresentOrElse(component -> {
            this.lastMessageOriginal = EncryptionUtil.recreate((class_2561)msg);
            this.lastMessageEncrypted = true;
        }, () -> {
            this.lastMessageEncrypted = false;
        });
        return this.lastMessageEncrypted ? (class_5348)decrypted.get() : msg;
    }
}

