/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium.sodiumCompat;

import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexFormat;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.Material;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkMeshAttribute;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexEncoder;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexType;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.util.ColorU8;
import org.lwjgl.system.MemoryUtil;

public class NvidiumCompactChunkVertex
implements ChunkVertexType {
    public static final GlVertexFormat<ChunkMeshAttribute> VERTEX_FORMAT = new GlVertexFormat(ChunkMeshAttribute.class, null, 16);
    public static final int STRIDE = 16;
    public static final NvidiumCompactChunkVertex INSTANCE = new NvidiumCompactChunkVertex();
    private static final int POSITION_MAX_VALUE = 65536;
    public static final int TEXTURE_MAX_VALUE = 32768;
    private static final float MODEL_ORIGIN = 8.0f;
    private static final float MODEL_RANGE = 32.0f;
    private static final float MODEL_SCALE = 4.8828125E-4f;
    private static final float MODEL_SCALE_INV = 2048.0f;
    private static final float TEXTURE_SCALE = 3.0517578E-5f;

    public float getTextureScale() {
        return 3.0517578E-5f;
    }

    public float getPositionScale() {
        return 4.8828125E-4f;
    }

    public float getPositionOffset() {
        return -8.0f;
    }

    public GlVertexFormat<ChunkMeshAttribute> getVertexFormat() {
        return VERTEX_FORMAT;
    }

    public ChunkVertexEncoder getEncoder() {
        return (ptr, material, vertex, sectionIndex) -> {
            MemoryUtil.memPutInt((long)(ptr + 0L), (int)(NvidiumCompactChunkVertex.encodePosition(vertex.x) << 0 | NvidiumCompactChunkVertex.encodePosition(vertex.y) << 16));
            MemoryUtil.memPutInt((long)(ptr + 4L), (int)(NvidiumCompactChunkVertex.encodePosition(vertex.z) << 0 | NvidiumCompactChunkVertex.encodeDrawParameters(material, sectionIndex) << 16));
            MemoryUtil.memPutInt((long)(ptr + 8L), (int)(NvidiumCompactChunkVertex.encodeColor(vertex.color) << 0 | NvidiumCompactChunkVertex.encodeLight(vertex.light) << 24));
            MemoryUtil.memPutInt((long)(ptr + 12L), (int)NvidiumCompactChunkVertex.encodeTexture(vertex.u, vertex.v));
            return ptr + 16L;
        };
    }

    private static int encodePosition(float v) {
        return (int)((8.0f + v) * 2048.0f);
    }

    private static int encodeDrawParameters(Material material, int sectionIndex) {
        return (sectionIndex & 0xFF) << 8 | (material.bits() & 0xFF) << 0;
    }

    private static int encodeColor(int color) {
        float brightness = ColorU8.byteToNormalizedFloat((int)ColorABGR.unpackAlpha((int)color));
        int r = ColorU8.normalizedFloatToByte((float)(ColorU8.byteToNormalizedFloat((int)ColorABGR.unpackRed((int)color)) * brightness));
        int g = ColorU8.normalizedFloatToByte((float)(ColorU8.byteToNormalizedFloat((int)ColorABGR.unpackGreen((int)color)) * brightness));
        int b = ColorU8.normalizedFloatToByte((float)(ColorU8.byteToNormalizedFloat((int)ColorABGR.unpackBlue((int)color)) * brightness));
        return ColorABGR.pack((int)r, (int)g, (int)b, (int)0);
    }

    private static int encodeLight(int light) {
        int block = light >> 4 & 0xF;
        int sky = light >> 20 & 0xF;
        return block << 0 | sky << 4;
    }

    private static int encodeTexture(float u, float v) {
        return (Math.round(u * 32768.0f) & 0xFFFF) << 0 | (Math.round(v * 32768.0f) & 0xFFFF) << 16;
    }
}

