/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.render.texture;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.minecraft.class_1068;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_640;
import org.jetbrains.annotations.NotNull;
import su.plo.slib.api.entity.player.McGameProfile;

public final class ModPlayerSkins {
    private static final Cache<UUID, Supplier<class_2960>> SKINS = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.SECONDS).build();

    public static synchronized void loadSkin(@NotNull UUID playerId, @NotNull String nick, @NotNull ScheduledExecutorService backgroundExecutor) {
        class_640 playerInfo = class_310.method_1551().method_1562().method_2871(playerId);
        if (playerInfo != null) {
            return;
        }
        Supplier skinLocation = (Supplier)SKINS.getIfPresent((Object)playerId);
        if (skinLocation != null) {
            return;
        }
        backgroundExecutor.execute(() -> {
            GameProfile profile = class_310.method_1551().method_1495().fillProfileProperties(new GameProfile(playerId, nick), false);
            SKINS.put((Object)profile.getId(), ModPlayerSkins.getInsecureSkinLocation(profile));
        });
    }

    public static synchronized void loadSkin(@NotNull McGameProfile gameProfile) {
        class_640 playerInfo = class_310.method_1551().method_1562().method_2871(gameProfile.getId());
        if (playerInfo != null) {
            return;
        }
        Supplier<class_2960> skinLocation = (Supplier<class_2960>)SKINS.getIfPresent((Object)gameProfile.getId());
        if (skinLocation != null) {
            return;
        }
        GameProfile profile = new GameProfile(gameProfile.getId(), gameProfile.getName());
        gameProfile.getProperties().forEach(property -> profile.getProperties().put((Object)property.getName(), (Object)new Property(property.getName(), property.getValue(), property.getSignature())));
        skinLocation = ModPlayerSkins.getInsecureSkinLocation(profile);
        SKINS.put((Object)gameProfile.getId(), skinLocation);
    }

    private static Supplier<class_2960> getInsecureSkinLocation(GameProfile gameProfile) {
        MinecraftProfileTexture minecraftProfileTexture = (MinecraftProfileTexture)class_310.method_1551().method_1582().method_4654(gameProfile).get(MinecraftProfileTexture.Type.SKIN);
        return minecraftProfileTexture != null ? () -> class_310.method_1551().method_1582().method_4656(minecraftProfileTexture, MinecraftProfileTexture.Type.SKIN) : () -> ModPlayerSkins.getDefaultSkin(gameProfile.getId());
    }

    @NotNull
    public static synchronized class_2960 getSkin(@NotNull UUID playerId, @NotNull String nick) {
        class_640 playerInfo = class_310.method_1551().method_1562().method_2871(playerId);
        if (playerInfo != null) {
            return playerInfo.method_2968();
        }
        Supplier skinLocation = (Supplier)SKINS.getIfPresent((Object)playerId);
        if (skinLocation != null) {
            return (class_2960)skinLocation.get();
        }
        return ModPlayerSkins.getDefaultSkin(playerId);
    }

    @NotNull
    public static class_2960 getDefaultSkin(@NotNull UUID playerId) {
        return class_1068.method_4648((UUID)playerId);
    }

    private ModPlayerSkins() {
    }
}

