/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.audio.codec.opus;

import su.plo.voice.api.audio.codec.CodecException;
import su.plo.voice.audio.codec.opus.BaseOpusDecoder;
import su.plo.voice.libs.concentus.OpusDecoder;
import su.plo.voice.libs.concentus.OpusException;

public final class JavaOpusDecoder
implements BaseOpusDecoder {
    private final int sampleRate;
    private final int channels;
    private final int frameSize;
    private OpusDecoder decoder;
    private short[] buffer;

    public JavaOpusDecoder(int sampleRate, boolean stereo, int frameSize) {
        this.sampleRate = sampleRate;
        this.channels = stereo ? 2 : 1;
        this.frameSize = frameSize;
    }

    @Override
    public short[] decode(byte[] encoded) throws CodecException {
        int result2;
        if (!this.isOpen()) {
            throw new CodecException("Decoder is not open");
        }
        try {
            result2 = encoded == null || encoded.length == 0 ? this.decoder.decode(null, 0, 0, this.buffer, 0, this.frameSize, false) : this.decoder.decode(encoded, 0, encoded.length, this.buffer, 0, this.frameSize, false);
        }
        catch (OpusException e) {
            throw new CodecException("Failed to decode audio", e);
        }
        short[] decoded = encoded == null || encoded.length == 0 ? new short[result2] : new short[result2 * this.channels];
        System.arraycopy(this.buffer, 0, decoded, 0, decoded.length);
        return decoded;
    }

    @Override
    public void open() throws CodecException {
        try {
            this.decoder = new OpusDecoder(this.sampleRate, this.channels);
            this.buffer = new short[this.frameSize * this.channels];
        }
        catch (OpusException e) {
            throw new CodecException("Failed to open opus decoder", e);
        }
    }

    @Override
    public void reset() {
        if (!this.isOpen()) {
            return;
        }
        this.decoder.resetState();
    }

    @Override
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        this.decoder = null;
        this.buffer = null;
    }

    @Override
    public boolean isOpen() {
        return this.decoder != null;
    }

    @Override
    public short[] decodePLC() throws CodecException {
        return this.decode(null);
    }
}

