/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.data.audio.codec;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.util.Map;
import su.plo.voice.proto.packets.PacketSerializable;

public class CodecInfo
implements PacketSerializable {
    protected String name;
    protected Map<String, String> params;

    @Override
    public void deserialize(ByteArrayDataInput in) {
        this.name = in.readUTF();
        this.params = Maps.newHashMap();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.params.put(in.readUTF(), in.readUTF());
        }
    }

    @Override
    public void serialize(ByteArrayDataOutput out) {
        out.writeUTF((String)Preconditions.checkNotNull((Object)this.name));
        Preconditions.checkNotNull(this.params);
        out.writeInt(this.params.size());
        this.params.forEach((key, value) -> {
            out.writeUTF(key);
            out.writeUTF(value);
        });
    }

    public CodecInfo(String name, Map<String, String> params) {
        this.name = name;
        this.params = params;
    }

    public CodecInfo() {
    }

    public String toString() {
        return "CodecInfo(name=" + this.getName() + ", params=" + this.getParams() + ")";
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getParams() {
        return this.params;
    }
}

