/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.packets.tcp.clientbound;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.UUID;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.PacketUtil;
import su.plo.voice.proto.packets.tcp.clientbound.ClientPacketTcpHandler;

public final class ActivationUnregisterPacket
implements Packet<ClientPacketTcpHandler> {
    private UUID activationId;

    @Override
    public void read(ByteArrayDataInput in) throws IOException {
        this.activationId = PacketUtil.readUUID(in);
    }

    @Override
    public void write(ByteArrayDataOutput out) throws IOException {
        PacketUtil.writeUUID(out, (UUID)Preconditions.checkNotNull((Object)this.activationId));
    }

    @Override
    public void handle(ClientPacketTcpHandler handler) {
        handler.handle(this);
    }

    public ActivationUnregisterPacket(UUID activationId) {
        this.activationId = activationId;
    }

    public ActivationUnregisterPacket() {
    }

    public String toString() {
        return "ActivationUnregisterPacket(activationId=" + this.getActivationId() + ")";
    }

    public UUID getActivationId() {
        return this.activationId;
    }
}

