/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.packets.tcp.clientbound;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.proto.data.audio.capture.CaptureInfo;
import su.plo.voice.proto.data.audio.capture.VoiceActivation;
import su.plo.voice.proto.data.audio.line.VoiceSourceLine;
import su.plo.voice.proto.data.encryption.EncryptionInfo;
import su.plo.voice.proto.packets.PacketUtil;
import su.plo.voice.proto.packets.tcp.clientbound.ClientPacketTcpHandler;
import su.plo.voice.proto.packets.tcp.clientbound.ConfigPlayerInfoPacket;

public final class ConfigPacket
extends ConfigPlayerInfoPacket {
    private UUID serverId;
    private CaptureInfo captureInfo;
    @Nullable
    private EncryptionInfo encryption;
    private Set<VoiceSourceLine> sourceLines;
    private Set<VoiceActivation> activations;

    public ConfigPacket(@NotNull UUID serverId, @NotNull CaptureInfo captureInfo, @Nullable EncryptionInfo encryption, @NotNull Set<VoiceSourceLine> sourceLines, @NotNull Set<VoiceActivation> activations, @NotNull Map<String, Boolean> permissions) {
        super(permissions);
        this.serverId = serverId;
        this.captureInfo = captureInfo;
        this.encryption = encryption;
        this.sourceLines = sourceLines;
        this.activations = activations;
    }

    public Collection<VoiceSourceLine> getSourceLines() {
        return this.sourceLines;
    }

    public Collection<VoiceActivation> getActivations() {
        return this.activations;
    }

    @Override
    public void read(ByteArrayDataInput in) throws IOException {
        int i;
        this.serverId = PacketUtil.readUUID(in);
        this.captureInfo = new CaptureInfo();
        this.captureInfo.deserialize(in);
        if (in.readBoolean()) {
            this.encryption = new EncryptionInfo();
            this.encryption.deserialize(in);
        }
        this.sourceLines = Sets.newHashSet();
        int size = in.readInt();
        for (i = 0; i < size; ++i) {
            VoiceSourceLine sourceLine = new VoiceSourceLine();
            sourceLine.deserialize(in);
            this.sourceLines.add(sourceLine);
        }
        this.activations = Sets.newHashSet();
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            VoiceActivation activation = new VoiceActivation();
            activation.deserialize(in);
            this.activations.add(activation);
        }
        super.read(in);
    }

    @Override
    public void write(ByteArrayDataOutput out) throws IOException {
        PacketUtil.writeUUID(out, this.serverId);
        ((CaptureInfo)Preconditions.checkNotNull((Object)this.captureInfo)).serialize(out);
        out.writeBoolean(this.encryption != null);
        if (this.encryption != null) {
            this.encryption.serialize(out);
        }
        out.writeInt(this.sourceLines.size());
        for (VoiceSourceLine sourceLine : this.sourceLines) {
            sourceLine.serialize(out);
        }
        out.writeInt(this.activations.size());
        this.activations.forEach(activation -> activation.serialize(out));
        super.write(out);
    }

    @Override
    public void handle(ClientPacketTcpHandler handler) {
        handler.handle(this);
    }

    public ConfigPacket() {
    }

    @Override
    public String toString() {
        return "ConfigPacket(serverId=" + this.getServerId() + ", captureInfo=" + this.getCaptureInfo() + ", encryption=" + this.getEncryption() + ", sourceLines=" + this.getSourceLines() + ", activations=" + this.getActivations() + ")";
    }

    public UUID getServerId() {
        return this.serverId;
    }

    public CaptureInfo getCaptureInfo() {
        return this.captureInfo;
    }

    @Nullable
    public EncryptionInfo getEncryption() {
        return this.encryption;
    }
}

