/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.packets.tcp.clientbound;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import su.plo.slib.api.entity.player.McGameProfile;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.PacketUtil;
import su.plo.voice.proto.packets.tcp.clientbound.ClientPacketTcpHandler;
import su.plo.voice.proto.serializer.McGameProfileSerializer;

public final class SourceLinePlayersListPacket
implements Packet<ClientPacketTcpHandler> {
    private UUID lineId;
    private List<McGameProfile> players;

    public SourceLinePlayersListPacket(@NotNull UUID lineId) {
        this.lineId = lineId;
        this.players = ImmutableList.of();
    }

    @Override
    public void read(ByteArrayDataInput in) throws IOException {
        this.lineId = PacketUtil.readUUID(in);
        this.players = PacketUtil.readList(in, McGameProfileSerializer.INSTANCE);
    }

    @Override
    public void write(ByteArrayDataOutput out) throws IOException {
        PacketUtil.writeUUID(out, (UUID)Preconditions.checkNotNull((Object)this.lineId));
        PacketUtil.writeList(out, McGameProfileSerializer.INSTANCE, (List)Preconditions.checkNotNull(this.players));
    }

    @Override
    public void handle(ClientPacketTcpHandler handler) {
        handler.handle(this);
    }

    public SourceLinePlayersListPacket(UUID lineId, List<McGameProfile> players) {
        this.lineId = lineId;
        this.players = players;
    }

    public SourceLinePlayersListPacket() {
    }

    public String toString() {
        return "SourceLinePlayersListPacket(lineId=" + this.getLineId() + ", players=" + this.getPlayers() + ")";
    }

    public UUID getLineId() {
        return this.lineId;
    }

    public List<McGameProfile> getPlayers() {
        return this.players;
    }
}

