/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.socket;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.BaseVoice;
import su.plo.voice.api.server.event.connection.UdpClientDisconnectedEvent;
import su.plo.voice.api.server.socket.UdpServerConnection;
import su.plo.voice.proto.packets.udp.bothbound.PingPacket;
import su.plo.voice.server.BaseVoiceServer;

public final class NettyUdpKeepAlive {
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private final BaseVoiceServer voiceServer;

    public NettyUdpKeepAlive(@NotNull BaseVoiceServer voiceServer) {
        this.voiceServer = voiceServer;
        this.executor.scheduleAtFixedRate(this::tick, 0L, 3L, TimeUnit.SECONDS);
    }

    public void close() {
        this.executor.shutdown();
    }

    private void tick() {
        long now = System.currentTimeMillis();
        PingPacket packet = new PingPacket();
        for (UdpServerConnection connection : this.voiceServer.getUdpConnectionManager().getConnections()) {
            if (now - connection.getKeepAlive() > (long)this.voiceServer.getConfig().voice().keepAliveTimeoutMs()) {
                BaseVoice.DEBUG_LOGGER.log("UDP connection timed out: {}", connection);
                this.voiceServer.getUdpConnectionManager().removeConnection(connection, UdpClientDisconnectedEvent.Reason.TIMED_OUT);
                this.voiceServer.getTcpPacketManager().requestPlayerInfo(connection.getPlayer());
                continue;
            }
            if (now - connection.getSentKeepAlive() < 1000L) continue;
            connection.setSentKeepAlive(now);
            connection.sendPacket(packet);
        }
    }
}

