/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.math.EMFMathException;
import traben.entity_model_features.models.animation.math.MathComponent;
import traben.entity_model_features.models.animation.math.MathConstant;
import traben.entity_model_features.models.animation.math.MathExpressionParser;
import traben.entity_model_features.models.animation.math.MathValue;
import traben.entity_model_features.models.animation.math.methods.MethodRegistry;

public abstract class MathMethod
extends MathValue
implements MathComponent {
    protected MathComponent optimizedAlternativeToThis = null;
    protected MathValue.ResultSupplier supplier = null;

    protected MathMethod(boolean isNegative, EMFAnimation calculationInstance, int argCount) throws EMFMathException {
        super(isNegative);
        if (!this.hasCorrectArgCount(argCount)) {
            throw new EMFMathException("ERROR: wrong number of arguments [" + argCount + "] in [" + this.getClass().getSimpleName() + "] for [" + calculationInstance.animKey + "] in [" + calculationInstance.modelName + "].");
        }
    }

    protected static MathComponent parseArg(String arg, EMFAnimation calculationInstance) throws EMFMathException {
        if (arg == null || arg.isBlank()) {
            throw new EMFMathException("Method argument parsing error [" + arg + "] in [" + calculationInstance.animKey + "] in [" + calculationInstance.modelName + "].");
        }
        MathComponent ret = MathExpressionParser.getOptimizedExpression(arg, false, calculationInstance);
        if (ret == MathExpressionParser.NULL_EXPRESSION) {
            throw new EMFMathException("Method argument parsing null [" + arg + "] in [" + calculationInstance.animKey + "] in [" + calculationInstance.modelName + "].");
        }
        return ret;
    }

    protected static List<MathComponent> parseAllArgs(List<String> args, EMFAnimation calculationInstance) throws EMFMathException {
        if (args == null || args.isEmpty()) {
            throw new EMFMathException("Method argument parsing error [" + args + "] in [" + calculationInstance.animKey + "] in [" + calculationInstance.modelName + "].");
        }
        ArrayList<MathComponent> expressionList = new ArrayList<MathComponent>();
        for (String arg : args) {
            expressionList.add(MathMethod.parseArg(arg, calculationInstance));
        }
        return expressionList;
    }

    private static MathMethod of(String methodNameIn, String args, boolean isNegative, EMFAnimation calculationInstance) throws EMFMathException {
        String methodName;
        boolean booleanInvert = methodNameIn.startsWith("!");
        String string = methodName = booleanInvert ? methodNameIn.substring(1) : methodNameIn;
        if (!MethodRegistry.getInstance().containsMethod(methodName)) {
            throw new EMFMathException("ERROR: Unknown method [" + methodName + "], rejecting animation expression for [" + calculationInstance.animKey + "].");
        }
        List<String> argsList = MathMethod.getArgsList(args);
        MathMethod method = MethodRegistry.getInstance().getMethodFactory(methodName).getMethod(argsList, isNegative, calculationInstance);
        if (booleanInvert) {
            method.invertSupplierBoolean();
        }
        return method;
    }

    @NotNull
    private static List<String> getArgsList(String args) {
        ArrayList<String> argsList = new ArrayList<String>();
        int openBracketCount = 0;
        StringBuilder builder = new StringBuilder();
        Iterator charIterator = args.chars().mapToObj(c -> Character.valueOf((char)c)).iterator();
        int lastChar = 0;
        while (charIterator.hasNext()) {
            char ch = ((Character)charIterator.next()).charValue();
            if (lastChar == 92) {
                builder.append(ch);
                lastChar = 0;
                continue;
            }
            if (ch == '(') {
                ++openBracketCount;
            } else if (ch == ')') {
                --openBracketCount;
            } else if (ch == ',' && openBracketCount == 0) {
                argsList.add(builder.toString().trim());
                builder.setLength(0);
                continue;
            }
            builder.append(ch);
            lastChar = ch;
        }
        if (!builder.isEmpty()) {
            argsList.add(builder.toString().trim());
        }
        return argsList;
    }

    static MathComponent getOptimizedExpression(String methodName, String args, boolean isNegative, EMFAnimation calculationInstance) throws EMFMathException {
        if (methodName.startsWith("-")) {
            isNegative = true;
            methodName = methodName.substring(1);
        }
        MathMethod method = MathMethod.of(methodName, args, isNegative, calculationInstance);
        return Objects.requireNonNullElse(method.optimizedAlternativeToThis, method);
    }

    protected void setOptimizedAlternativeToThis(MathComponent optimizedAlternativeToThis) {
        this.optimizedAlternativeToThis = optimizedAlternativeToThis;
    }

    protected boolean canOptimizeForConstantArgs() {
        return true;
    }

    protected void setSupplierAndOptimize(MathValue.ResultSupplier supplier) {
        this.supplier = supplier;
    }

    protected void setSupplierAndOptimize(MathValue.ResultSupplier supplier, MathComponent arg) {
        this.supplier = supplier;
        this.setOptimizedIfPossible(supplier, List.of(arg));
    }

    protected void setSupplierAndOptimize(MathValue.ResultSupplier supplier, List<MathComponent> allArgs) {
        this.supplier = supplier;
        this.setOptimizedIfPossible(supplier, allArgs);
    }

    protected abstract boolean hasCorrectArgCount(int var1);

    private void invertSupplierBoolean() {
        if (this.optimizedAlternativeToThis == null) {
            MathValue.ResultSupplier currentSupplier = this.supplier;
            this.supplier = () -> MathValue.invertBoolean(currentSupplier);
        } else {
            this.optimizedAlternativeToThis = new MathConstant(MathValue.invertBoolean(this.optimizedAlternativeToThis.getResult()), this.isNegative);
        }
    }

    protected void setOptimizedIfPossible(MathValue.ResultSupplier supplier, List<MathComponent> allComponents) {
        float constantResult;
        if (!this.canOptimizeForConstantArgs() || allComponents.isEmpty()) {
            return;
        }
        boolean foundNonConstant = allComponents.stream().anyMatch(comp -> !comp.isConstant());
        if (!foundNonConstant && !Float.isNaN(constantResult = supplier.get())) {
            this.optimizedAlternativeToThis = new MathConstant(constantResult, this.isNegative);
        }
    }

    @Override
    MathValue.ResultSupplier getResultSupplier() {
        return this.supplier;
    }
}

